/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ContentVersionStrategy;
import org.springframework.web.servlet.resource.FixedVersionStrategy;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.springframework.web.servlet.resource.VersionStrategy;

public class VersionResourceResolver
extends AbstractResourceResolver {
    public static final String RESOURCE_VERSION_ATTRIBUTE = VersionResourceResolver.class.getName() + ".resourceVersion";
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    private final Map<String, VersionStrategy> versionStrategyMap = new HashMap<String, VersionStrategy>();

    public void setStrategyMap(Map<String, VersionStrategy> map) {
        this.versionStrategyMap.clear();
        this.versionStrategyMap.putAll(map);
    }

    public Map<String, VersionStrategy> getStrategyMap() {
        return this.versionStrategyMap;
    }

    public VersionResourceResolver addContentVersionStrategy(String ... pathPatterns) {
        this.addVersionStrategy(new ContentVersionStrategy(), pathPatterns);
        return this;
    }

    public VersionResourceResolver addFixedVersionStrategy(String version, String ... pathPatterns) {
        this.addVersionStrategy(new FixedVersionStrategy(version), pathPatterns);
        return this;
    }

    public VersionResourceResolver addVersionStrategy(VersionStrategy strategy, String ... pathPatterns) {
        for (String pattern : pathPatterns) {
            this.getStrategyMap().put(pattern, strategy);
        }
        return this;
    }

    @Override
    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        Resource baseResource;
        Resource resolved = chain.resolveResource(request, requestPath, locations);
        if (resolved != null) {
            return resolved;
        }
        VersionStrategy versionStrategy = this.getStrategyForPath(requestPath);
        if (versionStrategy == null) {
            return null;
        }
        String candidateVersion = versionStrategy.extractVersion(requestPath);
        if (StringUtils.isEmpty((Object)candidateVersion)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No version found in path=\"" + requestPath + "\""));
            }
            return null;
        }
        String simplePath = versionStrategy.removeVersion(requestPath, candidateVersion);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Extracted version from path, re-resolving without version, path=\"" + simplePath + "\""));
        }
        if ((baseResource = chain.resolveResource(request, simplePath, locations)) == null) {
            return null;
        }
        String actualVersion = versionStrategy.getResourceVersion(baseResource);
        if (candidateVersion.equals(actualVersion)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"resource matches extracted version");
            }
            if (request != null) {
                request.setAttribute(RESOURCE_VERSION_ATTRIBUTE, (Object)candidateVersion);
            }
            return baseResource;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Potential resource found for [" + requestPath + "], but version [" + candidateVersion + "] doesn't match."));
        }
        return null;
    }

    @Override
    protected String resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String baseUrl = chain.resolveUrlPath(resourceUrlPath, locations);
        if (StringUtils.hasText((String)baseUrl)) {
            VersionStrategy versionStrategy = this.getStrategyForPath(resourceUrlPath);
            if (versionStrategy == null) {
                return null;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Getting the original resource to determine version");
            }
            Resource resource = chain.resolveResource(null, baseUrl, locations);
            String version = versionStrategy.getResourceVersion(resource);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Version=" + version));
            }
            return versionStrategy.addVersion(baseUrl, version);
        }
        return baseUrl;
    }

    protected VersionStrategy getStrategyForPath(String requestPath) {
        String path = "/".concat(requestPath);
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (String pattern : this.versionStrategyMap.keySet()) {
            if (!this.pathMatcher.match(pattern, path)) continue;
            matchingPatterns.add(pattern);
        }
        if (!matchingPatterns.isEmpty()) {
            Comparator comparator = this.pathMatcher.getPatternComparator(path);
            Collections.sort(matchingPatterns, comparator);
            return this.versionStrategyMap.get(matchingPatterns.get(0));
        }
        return null;
    }
}

